//
//  OPPasswordGeneratorCharacterView.h
//  ApplicationFrameworks
//
//  Created by Kevin Hayes on 2015-11-24.
//
//

#import <Cocoa/Cocoa.h>

@class OPPasswordGeneratorCharacterView;

@protocol OPPasswordGeneratorCharacterViewDelegate <NSObject>

- (void)passwordGeneratorCharacterViewLengthChanged:(OPPasswordGeneratorCharacterView *)passwordGeneratorCharacterView;
- (void)passwordGeneratorCharacterViewDigitCountChanged:(OPPasswordGeneratorCharacterView *)passwordGeneratorCharacterView;
- (void)passwordGeneratorCharacterViewSymbolCountChanged:(OPPasswordGeneratorCharacterView *)passwordGeneratorCharacterView;
- (void)passwordGeneratorCharacterViewAvoidAmbiguityChanged:(OPPasswordGeneratorCharacterView *)passwordGeneratorCharacterView;

@end

@interface OPPasswordGeneratorCharacterView : NSView

@property (nonatomic) NSUInteger length;
@property (nonatomic) NSUInteger digitCount;
@property (nonatomic) NSUInteger symbolCount;
@property (nonatomic) BOOL avoidAmbiguity;

@property (nonatomic, weak) id<OPPasswordGeneratorCharacterViewDelegate> delegate;

- (instancetype)initWithWidth:(CGFloat)width;

@end
